/* CalcElement.cp */

#include "CalcElement.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/*
	dataString (a C string) is good if of form: number or number/number
	theElement will then be calculated as theElement, and true returned.
	Else false is returned.
*/

bool calcElement(double& theElement, char* dataString)
{
	long		i, j, theLength, numSlashes;
	char		*numString, *denString, ch;
	double		num, den;
	
	theLength = strlen(dataString);
	if(theLength<1)
		return false;
		
	// determine the number of /'s
	numSlashes = 0;
	for(i=0;i<theLength;i++)
	{
		if(dataString[i]=='/')
			numSlashes++;
	}
	
	if(numSlashes>1)
		return false;
		
	if(numSlashes==0)
	{
		if(sscanf(dataString, "%lf", &theElement)==1)
			return true;
		else
			return false;
	}
	
	// now numSlashes=1
	numString = (char *)malloc((theLength+1)*sizeof(char));
	denString = (char *)malloc((theLength+1)*sizeof(char));
	
	i = 0;
	ch = dataString[i];
	while(ch!='/')
	{
		numString[i] = ch;
		ch = dataString[++i];
	}
	numString[i] = 0;
	
	if(!(sscanf(numString, "%lf", &num)==1) || (++i==theLength))
	{
		free(numString);
		free(denString);
		return false;
	}
	
	free(numString);
	
	ch = dataString[i];
	j = 0;
	while(i<theLength)
	{
		denString[j++] = ch;
		ch = dataString[++i];
	}
	denString[j] = 0;
	
	if(!(sscanf(denString, "%lf", &den)==1))
	{
		free(denString);
		return false;
	}
	
	if(den==0)
	{
		free(denString);
		return false;
	}
	
	theElement = num/den;
	free(denString);
	return true;

}/* calcElement */

